import { View, FlatList, Pressable, Text } from 'react-native';
import React, { useEffect, useRef, useState } from 'react';
import { myWishlistStyles } from './MyWishlistStyle';
import useAuth from '../../hooks/useAuth';
import { useSelector, useDispatch } from 'react-redux';
import BackNavigation from '../Utilities/CustomHeader/BackNavigation';
import { ProfileStyles } from '../Profile/ProfileStyle';
import {
    fetchWishlistStart,
    getMyAllWishlist,
    getMyWishlist,
} from '../../redux/slices/user/myWishlist/getMyWishlist';
import { refresh } from '../../redux/slices/user/util/refresh';
import CategoriesSkeleton from '../../src/skeletons/screens/Categories/CategoriesSkeleton';
import EmptyContent from '../Utilities/EmptyContent/EmptyContent';
import NoWishlistIcon from '../../assets/svgs/empty content/noWishlist.svg';
import { mutation } from '../../redux/slices/util/apiRequest';
import SingleWishlist from './SingleWishlist';
import useCustomToast from '../../hooks/useCustomToast';
import Toast from 'react-native-toast-message';

import { BASE_API_URL_STG } from '@env';
import useLangTranslation from '../../hooks/useLangTranslation';
import dpr from '../Utilities/CustomStyleAttribute/dpr';

const MyWishlist = (props) => {
    const { trans } = useLangTranslation();
    const dispatch = useDispatch();
    const { access_token } = useAuth();
    const showToast = useCustomToast();
    const WISHLIST_URL = `${BASE_API_URL_STG}/user/wishlists`;
    const { myWishlist, loading, isRefresh } = useSelector(
        (state) => state.getMyWishlistSlice
    );
    const [isUndoPopup, setIsUndoPopup] = useState(false);
    const [undo, setUndo] = useState(false);
    const undoRef = useRef(false);
    const [undoData, setUndoData] = useState({});
    const [insertPosition, setInsertPosition] = useState(null);
    const deleteFromDB = useRef([]);
    const [dltLoading, setDltLoading] = useState(false);

    useEffect(() => {
        dispatch(getMyWishlist({ access_token, URL: WISHLIST_URL }));
    }, []);

    useEffect(() => {
        if (undo) {
            const newWishlist = [...myWishlist];
            if(Array.isArray(undoData)) {
                dispatch(getMyAllWishlist(undoData));
            } else {
                newWishlist.splice(insertPosition, 0, undoData);
                dispatch(getMyAllWishlist(newWishlist));
            }
            setIsUndoPopup(false);
            Toast.hide();
            setUndo(false);
            setUndoData({});
        }
    }, [undo]);

    const handleWishlistDelete = (id) => {
        const undoData = myWishlist.find((item, index) => {
            if (item.id === id) {
                setInsertPosition(index);
                return item;
            }
        });
        setUndoData(undoData);
        const restWishlist = myWishlist.filter(
            (wishlist) => wishlist.id !== id
        );
        dispatch(getMyAllWishlist(restWishlist));
        setIsUndoPopup(true);

        setDltLoading(true)
        const timeoutId = setTimeout(async () => {
            setIsUndoPopup(false);
            const lastId =
                deleteFromDB.current[deleteFromDB.current.length - 1];
            if (undoRef.current == true) {
                if (lastId != timeoutId) {
                    try {
                        const URL = `${BASE_API_URL_STG}/user/wishlist/delete/${id}`;
                        await mutation(URL, 'DELETE', {}, access_token);
                        dispatch(getMyWishlist({ access_token, URL: WISHLIST_URL }));
                        setDltLoading(false)
                    } catch (e) {
                        setDltLoading(false)
                    }
                } else {
                    setDltLoading(false)
                    undoRef.current = false;
                }
            } else if (undoRef.current == false) {
                try {
                    const URL = `${BASE_API_URL_STG}/user/wishlist/delete/${id}`;
                    await mutation(URL, 'DELETE', {}, access_token);
                    dispatch(getMyWishlist({ access_token, URL: WISHLIST_URL }));
                    setDltLoading(false)
                } catch (e) {
                    setDltLoading(false)
                }
            }
            deleteFromDB.current = deleteFromDB.current.filter(
                (i) => i !== timeoutId
            );
        }, 4000);
        deleteFromDB.current = [...deleteFromDB.current, timeoutId];
    };

    useEffect(() => {
        if (isUndoPopup) {
            showToast({
                text1: trans('Item is removed from wishlist.'),
                type: 'undo',
                position: 'bottom',
                bottomOffset: dpr(20),
                props: {
                    func: () => {
                        setUndo(true);
                        undoRef.current = true;
                    },
                },
            });
        }
    }, [isUndoPopup]);

    const handleRemoveAllWishlist = async () => {
        setUndoData(myWishlist)
        dispatch(getMyAllWishlist([]));
        setIsUndoPopup(true);

        setDltLoading(true);

        setTimeout(async() => {
            setIsUndoPopup(false);
            if(undoRef.current == false) {
                let allIds = '?';
                if (myWishlist?.length > 0) {
                    myWishlist.forEach((wishlist) => {
                        allIds = allIds + `ids[]=${wishlist.id}&`;
                    });
                }
    
                try {
                    const URL = `${BASE_API_URL_STG}/user/wishlist/delete${allIds.slice(
                        0,
                        -1
                    )}`;
                    await mutation(URL, 'DELETE', {}, access_token);
                    setDltLoading(false);
                } catch (e) {
                    setDltLoading(false);
                }
            } else {
                setDltLoading(false);
            }
            }, 4000)
    };

    const onRefresh = () => {
        if (!isUndoPopup && !dltLoading) {
            refresh(
                access_token,
                WISHLIST_URL,
                dispatch,
                fetchWishlistStart,
                getMyAllWishlist
            );
        }
    };

    const [fastLoad, setFastLoad] = useState(true);
    useEffect(() => setFastLoad(false), []);
    if (fastLoad) return <View />;

    return (
        <>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans('My Wishlist')}
                capitalize={false}
            />
            <View style={ProfileStyles.hrLine} />
            {loading ? (
                <CategoriesSkeleton />
            ) : (
                <>
                    {/* {myWishlist?.length > 0 && (
                        <Pressable
                            style={myWishlistStyles.clearAllCont}
                            onPress={handleRemoveAllWishlist}
                        >
                            <Text style={myWishlistStyles.clearAllText}>
                                {txtSliceFmt(trans("Clear All"), 12)}
                            </Text>
                        </Pressable>
                    )} */}
                    <View style={myWishlistStyles.container}>
                        {myWishlist?.length > 0 ? (
                            <FlatList
                                data={myWishlist}
                                renderItem={({ item }) => (
                                    <SingleWishlist
                                        item={item}
                                        handleWishlistDelete={
                                            handleWishlistDelete
                                        }
                                    />
                                )}
                                keyExtractor={(item) => item?.id}
                                refreshing={isRefresh}
                                onRefresh={onRefresh}
                                showsVerticalScrollIndicator={false}
                            />
                        ) : (
                            <FlatList
                                refreshing={isRefresh}
                                onRefresh={onRefresh}
                                showsVerticalScrollIndicator={false}
                                ListHeaderComponent={() => (
                                    <EmptyContent
                                        Icon={NoWishlistIcon}
                                        text={trans("No Items Saved For Later")}
                                    />
                                )}
                            />
                        )}
                    </View>
                </>
            )}
        </>
    );
};

export default MyWishlist;
